//+------------------------------------------------------------------+
//|                                                          310.mq4 |
//|                                       Copyright  2007 Tom Balfe |
//|                                                                  |
//| 3-10 Oscillator                                                  |
//| "Hello I am looking for oscillator that is the difference        |
//| between a 3 and 10 period simple moving average, with a          |
//| 16-period simple moving average of the 3/10."                    |
//|                                                                  |
//| A question from forex-tsd forums. It's basically a variant of    |
//| MACD and/or PPO.                                                 | 
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007 Tom Balfe"
#property link      "redcarsarasota@yahoo.com"

#property indicator_separate_window
#property indicator_buffers 2
#property indicator_color1 ForestGreen
#property indicator_color2 Red
#property indicator_width1 2
#property indicator_width2 1
#property indicator_style2 2
//---- user changeable stuff
extern int FastSMA=3;
extern int SlowSMA=10;
extern int SignalSMA=16;
//---- two buffers
double     ThreeTenBuffer[];
double     SignalBuffer[];

int init()
  {

   SetIndexStyle(0,DRAW_LINE);
   SetIndexStyle(1,DRAW_LINE);
   SetIndexDrawBegin(1,SignalSMA);
   IndicatorDigits(Digits+1);
   SetIndexBuffer(0,ThreeTenBuffer);
   SetIndexBuffer(1,SignalBuffer);

   IndicatorShortName("3-10 Oscillator ("+FastSMA+","+SlowSMA+","+SignalSMA+")");
   SetIndexLabel(0,"310");
   SetIndexLabel(1,"Signal");

   return(0);
  }
 
int start()
  {
   int limit;
   int counted_bars=IndicatorCounted();
   //---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   limit=Bars-counted_bars;

   //---- FastSMA-SlowSMA
   //---- 310 counted in the 1st buffer
   for(int i=0; i<limit; i++)
      ThreeTenBuffer[i]=iMA(NULL,0,FastSMA,0,MODE_SMA,PRICE_CLOSE,i)-iMA(NULL,0,SlowSMA,0,MODE_SMA,PRICE_CLOSE,i);
   //---- signal line counted in the 2nd buffer
   for(i=0; i<limit; i++)
      SignalBuffer[i]=iMAOnArray(ThreeTenBuffer,Bars,SignalSMA,0,MODE_SMA,i);

   return(0);
  }

